<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * The view for the connection status of the plugin.
 *
 * @package    I10n_Push_Subscriber
 * @subpackage I10n_Push_Subscriber/admin/partials
 */

// These variables are prepared in the I10n_Push_Subscriber_Admin class.
// @var string $connection_status
// @var string $admin_email
?>
<div class="wrap" id="i10n-push-subscriber-admin">
	<h1><?php echo esc_html( get_admin_page_title() ); ?></h1>

	<div class="i10n-push-admin-notices">
		<!-- Admin notices will be displayed here by JavaScript -->
	</div>

	<div class="i10n-push-card">
		<h2><?php esc_html_e( '網站連接狀態', 'i10n-push-subscriber' ); ?></h2>
		<p>
			<strong><?php esc_html_e( '目前狀態：', 'i10n-push-subscriber' ); ?></strong>
			<span id="i10n-push-connection-status-display" class="i10n-push-status-<?php echo esc_attr( $connection_status ); ?>">
				<?php
				if ( 'pending' === $connection_status ) {
					esc_html_e( '等待驗證', 'i10n-push-subscriber' );
				} else {
					esc_html_e( '尚未連接', 'i10n-push-subscriber' );
				}
				?>
			</span>
		</p>

		<p>
			<?php esc_html_e( '將您的網站連接到 WordPress 中文補完計劃服務，以啟用自動化翻譯與訂閱功能。', 'i10n-push-subscriber' ); ?><br>
			<?php /* translators: %s: current site URL. */ ?>
			<small><?php printf( esc_html__( '請注意：啟用後，您的訂閱將與本網站網址 (%s) 綁定，無法轉移至其他網站。', 'i10n-push-subscriber' ), '<strong>' . esc_html( get_site_url() ) . '</strong>' ); ?></small>
		</p>

		<hr />

		<div class="i10n-push-connect-actions" style="display:flex; flex-wrap:wrap; gap:8px; align-items:center;">
			<?php
			$current_site = get_site_url();
			$tos_nonce    = get_option( 'i10n_push_tos_nonce' );
			if ( empty( $tos_nonce ) ) {
				$tos_nonce = wp_generate_password( 32, false, false );
				update_option( 'i10n_push_tos_nonce', $tos_nonce );
			}
			$tos_url = 'https://gordon168.com/i10n-push-tos/?from_site=' . rawurlencode( $current_site ) . '&tos_nonce=' . rawurlencode( $tos_nonce );
			?>
			<a id="i10n-push-tos-link" href="<?php echo esc_url( $tos_url ); ?>" target="_blank" class="button button-secondary">
				<?php esc_html_e( '閱讀並同意服務條款', 'i10n-push-subscriber' ); ?>
			</a>
			<button id="i10n-push-check-tos-button" class="button button-secondary">
				<?php esc_html_e( '我已同意，重新檢查', 'i10n-push-subscriber' ); ?>
			</button>
			<span id="i10n-push-tos-status"></span>
		</div>

		<?php if ( 'pending' === $connection_status ) : ?>
			<p class="description">
				<?php esc_html_e( '已發送驗證郵件至您的管理員信箱 (', 'i10n-push-subscriber' ); ?>
				<code><?php echo esc_html( $admin_email ); ?></code>
				<?php esc_html_e( ')，請點擊信中的連結完成驗證。', 'i10n-push-subscriber' ); ?>
			</p>
			<button id="i10n-push-check-verification-button" class="button button-secondary">
				<?php esc_html_e( '手動檢查驗證狀態', 'i10n-push-subscriber' ); ?>
			</button>
		<?php else : ?>
			<div class="i10n-push-connect-actions" style="display:flex; flex-wrap:wrap; gap:8px; align-items:center; margin-top:8px;">
				<button id="i10n-push-connect-button" class="button button-primary" disabled>
					<?php esc_html_e( '一鍵連接', 'i10n-push-subscriber' ); ?>
				</button>
				<span class="description" style="margin:0;">
					<?php esc_html_e( '請先閱讀並同意服務條款後，才可連接網站。', 'i10n-push-subscriber' ); ?>
				</span>
			</div>
		<?php endif; ?>
	</div>
</div>
