﻿<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// These variables are prepared in the I10n_Push_Subscriber_Admin class.
// @var array $plugins
// @var array $themes
?>
<?php
$format_price_display = function( $price, $source ) {
    $price = (int) $price;
    if ( 'designated-free' === $source ) {
        /* translators: %d: yearly price in TWD. */
        return sprintf( esc_html__( 'NT$%d / 年 (首年最多 2 個免費，次年起按定價)', 'i10n-push-subscriber' ), $price );
    }
    /* translators: %d: yearly price in TWD. */
    return sprintf( esc_html__( 'NT$%d / 年', 'i10n-push-subscriber' ), $price );
};
?>

<?php
// Fallback: ensure i10n_push_data exists even if wp_localize_script is blocked.
$i10n_push_fallback = array(
    'ajax_url'    => admin_url( 'admin-ajax.php' ),
    'nonce'       => wp_create_nonce( 'i10n_push_nonce' ),
    'site_url'    => get_site_url(),
    'plugin_name' => 'i10n-push-subscriber',
    'managed_free_credit' => isset( $managed_free_credit ) ? $managed_free_credit : 0,
    'available_items' => isset( $available_items_data ) ? $available_items_data : array(),
);
?>
<script type="text/javascript">
window.i10n_push_data = window.i10n_push_data || <?php echo wp_json_encode( $i10n_push_fallback ); ?>;
</script>

<div class="wrap" id="i10n-push-subscriber-admin">
    <div id="i10n-push-system-notices"></div>
    <div class="i10n-push-top-row1">
        <h1><?php echo esc_html( get_admin_page_title() ); ?></h1>
        <div>
            <?php if ( ! empty( $contact_support_url ) ) : ?>
                <?php
                $contact_support_target = add_query_arg(
                    array(
                        'from_url' => get_site_url(),
                        'from_email' => get_option( 'admin_email' ),
                    ),
                    $contact_support_url
                );
                ?>
                <a href="<?php echo esc_url( $contact_support_target ); ?>" target="_blank" class="button button-primary" style="margin-right:8px;">
                    <?php esc_html_e( '聯絡客服', 'i10n-push-subscriber' ); ?>
                </a>
            <?php endif; ?>
            <?php if ( 'revoked' === $connection_status ) : ?>
                <button id="i10n-push-reapply-button" class="button button-secondary">
                    <?php esc_html_e( '重新申請連接', 'i10n-push-subscriber' ); ?>
                </button>
            <?php endif; ?>
        </div>
    </div>

    <div class="i10n-push-top-row3">
        <button id="force-refresh-button" class="button button-secondary i10n-push-action-secondary">
            <?php esc_html_e( '強制更新清單', 'i10n-push-subscriber' ); ?>
        </button>
        <button id="force-update-translations-button" class="button button-secondary btn-gap i10n-push-action-primary">
            <?php esc_html_e( '強制更新已訂閱翻譯', 'i10n-push-subscriber' ); ?>
        </button>
    </div>

    <?php if ( ! empty( $page_notices ) && is_array( $page_notices ) ) : ?>
        <?php foreach ( $page_notices as $notice ) : ?>
            <div class="notice notice-<?php echo esc_attr( $notice['type'] ?? 'info' ); ?>">
                <?php echo wp_kses_post( $notice['html'] ?? '' ); ?>
            </div>
        <?php endforeach; ?>
    
<?php endif; ?>

    <?php
    $managed_total = isset( $available_items_data['managed_free_credit_total'] ) ? (float) $available_items_data['managed_free_credit_total'] : 0;
    $managed_remaining = isset( $available_items_data['managed_free_credit_remaining'] ) ? (float) $available_items_data['managed_free_credit_remaining'] : ( $available_items_data['managed_free_credit'] ?? 0 );
    ?>
    <div class="i10n-push-top-row2">
        <div class="i10n-push-panel i10n-push-top-box i10n-push-panel-warning">
            <p><strong><?php esc_html_e( '早鳥優惠公告', 'i10n-push-subscriber' ); ?></strong></p>
            <ul style="margin-left: 20px; list-style: disc;">
                <li><?php esc_html_e( '超早鳥：2026/01/31 前下單，僅需原價 3 折', 'i10n-push-subscriber' ); ?></li>
                <li><?php esc_html_e( '早早鳥：2026/03/31 前下單，僅需原價 5 折', 'i10n-push-subscriber' ); ?></li>
                <li><?php esc_html_e( '早鳥：2026/05/31 前下單，僅需原價 7 折', 'i10n-push-subscriber' ); ?></li>
            </ul>
            <p><?php esc_html_e( '折扣依伺服器時間 (UTC+8) 計算，實際金額將於訂單建立時自動套用；早鳥優惠僅首年/首張付費訂單適用，第二年起恢復原價。', 'i10n-push-subscriber' ); ?></p>
        </div>
    </div>

    <div class="i10n-push-top-row4">
        <div class="i10n-push-panel i10n-push-top-box i10n-push-panel-info">
            <p>
                <strong><?php esc_html_e( '優惠方案', 'i10n-push-subscriber' ); ?></strong>:
                <?php esc_html_e( '我們精選了以下 5 個熱門外掛提供專業翻譯：Elementor, All in One SEO, LiteSpeed Cache, FluentForm, Wordfence Security。首年最多可免費訂閱 2 個；第二年起按定價收費。首年超過 2 個的訂閱將以原價計費。', 'i10n-push-subscriber' ); ?>
            </p>
        </div>
        <div class="i10n-push-panel i10n-push-top-box i10n-push-panel-success">
            <p>
                <strong><?php esc_html_e( '目前狀態', 'i10n-push-subscriber' ); ?></strong><br>
                <?php
                printf(
                    /* translators: 1: subscribed item count, 2: total discount in TWD, 3: total annual cost in TWD, 4: managed total, 5: managed remaining. */
                    esc_html__( '網站已連接 / 已訂閱 %1$d 個項目 / 指定免費（首年）優惠折抵 NT$%2$d / 續約年費總計 NT$%3$d / 代管免費折抵額度/餘額 NT$%4$s / NT$%5$s', 'i10n-push-subscriber' ),
                    (int) $subscribed_items_count,
                    (int) $total_discount,
                    (int) $total_annual_cost,
                    esc_html( number_format_i18n( $managed_total, 0 ) ),
                    esc_html( number_format_i18n( $managed_remaining, 0 ) )
                );
                ?>
            </p>
        </div>
    </div>

    <?php
    $renewal_at = $available_items_data['renewal_at'] ?? null;
    $renewal_timestamp = $renewal_at ? strtotime($renewal_at) : null;
    $grace_until = $renewal_timestamp ? strtotime('+30 days', $renewal_timestamp) : null;
    ?>
    <?php if ( $renewal_timestamp && time() >= $renewal_timestamp && ( 'connected' === $connection_status ) ) : ?>
        <p class="i10n-push-expiry-warning">
            <?php esc_html_e( '網站連接在到期一個月後將會中斷，所有訂閱的功能將不能再使用，如果在一個月期限內續約還是依原來的到期日計費，超過一個月期限則所有都歸零。', 'i10n-push-subscriber' ); ?>
        </p>
    <?php endif; ?>

    <p><?php esc_html_e( '請從下方清單中，勾選您希望訂閱專業翻譯的外掛與佈景主題。', 'i10n-push-subscriber' ); ?></p>

    <h2><?php esc_html_e( '外掛 (Plugins)', 'i10n-push-subscriber' ); ?></h2>
    <table class="wp-list-table widefat fixed striped i10n-push-table">
        <thead>
            <tr>
                <th scope="col" class="manage-column check-column"><input type="checkbox" id="select-all-plugins-checkbox" /></th>
                <th scope="col" class="manage-column"><?php esc_html_e( '項目名稱', 'i10n-push-subscriber' ); ?></th>
                <th scope="col" class="manage-column"><?php esc_html_e( '項目來源', 'i10n-push-subscriber' ); ?></th>
                <th scope="col" class="manage-column"><?php esc_html_e( '狀態', 'i10n-push-subscriber' ); ?></th>
                <th scope="col" class="manage-column"><?php esc_html_e( '官方翻譯', 'i10n-push-subscriber' ); ?></th>
                <th scope="col" class="manage-column"><?php esc_html_e( '訂閱到期日', 'i10n-push-subscriber' ); ?></th>
                <th scope="col" class="manage-column"><?php esc_html_e( '訂閱費用', 'i10n-push-subscriber' ); ?></th>
            </tr>
        </thead>
        <tbody>
            <?php if ( empty( $plugins ) ) : ?>
                <tr><td colspan="6"><?php esc_html_e( '您的網站尚未安裝任何外掛。', 'i10n-push-subscriber' ); ?></td></tr>
            <?php else : ?>
                <?php foreach ( $plugins as $item ) : ?>
                    <?php include I10N_PUSH_SUBSCRIBER_PLUGIN_DIR . 'admin/partials/i10n-push-subscriber-admin-item-row.php'; ?>
                <?php endforeach; ?>
            <?php endif; ?>
        </tbody>
    </table>

    <h2><?php esc_html_e( '佈景主題 (Themes)', 'i10n-push-subscriber' ); ?></h2>
    <table class="wp-list-table widefat fixed striped i10n-push-table">
        <thead>
            <tr>
                <th scope="col" class="manage-column check-column"><input type="checkbox" id="select-all-themes-checkbox" /></th>
                <th scope="col" class="manage-column"><?php esc_html_e( '項目名稱', 'i10n-push-subscriber' ); ?></th>
                <th scope="col" class="manage-column"><?php esc_html_e( '項目來源', 'i10n-push-subscriber' ); ?></th>
                <th scope="col" class="manage-column"><?php esc_html_e( '狀態', 'i10n-push-subscriber' ); ?></th>
                <th scope="col" class="manage-column"><?php esc_html_e( '官方翻譯', 'i10n-push-subscriber' ); ?></th>
                <th scope="col" class="manage-column"><?php esc_html_e( '訂閱到期日', 'i10n-push-subscriber' ); ?></th>
                <th scope="col" class="manage-column"><?php esc_html_e( '訂閱費用', 'i10n-push-subscriber' ); ?></th>
            </tr>
        </thead>
        <tbody>
            <?php if ( empty( $themes ) ) : ?>
                <tr><td colspan="6"><?php esc_html_e( '您的網站尚未安裝任何佈景主題。', 'i10n-push-subscriber' ); ?></td></tr>
            <?php else : ?>
                <?php foreach ( $themes as $item ) : ?>
                    <?php include I10N_PUSH_SUBSCRIBER_PLUGIN_DIR . 'admin/partials/i10n-push-subscriber-admin-item-row.php'; ?>
                <?php endforeach; ?>
            <?php endif; ?>
        </tbody>
    </table>

    <div id="i10n-push-summary" class="i10n-push-summary i10n-push-hidden">
        <p><?php esc_html_e( '本次選取原價總額:', 'i10n-push-subscriber' ); ?> <span id="i10n-push-subtotal">NT$ 0</span></p>
        <p><?php esc_html_e( '指定免費（首年）優惠折抵 (最多 2 個):', 'i10n-push-subscriber' ); ?> <span id="i10n-push-discount-designated">NT$ 0</span></p>
        <p><?php esc_html_e( '相依升級折抵:', 'i10n-push-subscriber' ); ?> <span id="i10n-push-discount-upgrade">NT$ 0</span></p>
        <p><?php esc_html_e( '代管免費折抵額度:', 'i10n-push-subscriber' ); ?> <span id="i10n-push-discount-managed">NT$ 0</span></p>
        <p><?php esc_html_e( '預估早鳥折扣:', 'i10n-push-subscriber' ); ?> <span id="i10n-push-discount-earlybird">NT$ 0</span> <span id="i10n-push-earlybird-label"></span></p>
        <p><strong><?php esc_html_e( '預估本次應付金額:', 'i10n-push-subscriber' ); ?> <span id="i10n-push-total">NT$ 0</span></strong></p>
        <p class="i10n-push-summary-note"><?php esc_html_e( '實際金額以收到的訂單付款通知為準', 'i10n-push-subscriber' ); ?></p>
    </div>

    <p class="submit">
        <button id="request-quote-button" class="button button-secondary i10n-push-hidden"><?php esc_html_e( '請求報價', 'i10n-push-subscriber' ); ?></button>
        <button id="save-subscriptions-button" class="button button-primary i10n-push-hidden"><?php esc_html_e( '訂閱選取項目', 'i10n-push-subscriber' ); ?></button>
    </p>
</div>


