<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Partial for displaying a single item row in the admin subscription table.
 *
 * This file is included within a foreach loop in i10n-push-subscriber-admin-display.php.
 * It expects the following variable to be available:
 * @var array $item The item data array (plugin or theme).
 */

$format_price_display = ( isset( $format_price_display ) && is_callable( $format_price_display ) )
    ? $format_price_display
    : function( $price, $source ) {
        $price = (int) $price;
        if ( 'designated-free' === $source ) {
            /* translators: %d: price in TWD per year. */
            return sprintf( __( 'NT$%d / 年 (首年最多 2 個免費，次年起按定價)', 'i10n-push-subscriber' ), $price );
        }
        /* translators: %d: price in TWD per year. */
        return sprintf( __( 'NT$%d / 年', 'i10n-push-subscriber' ), $price );
    };

$is_subscribed = $item['is_subscribed'] ?? false;
$tier = $item['tier'] ?? '';
$source = $item['source'] ?? '';
$price = $item['price'] ?? null;
$expires_at = $item['expires_at'] ?? null;
$is_active = isset( $item['is_active'] ) ? (bool) $item['is_active'] : true;
$is_child_theme = ! empty( $item['is_child_theme'] );
$dependency_missing = ! empty( $item['dependency_missing'] );
$requires_names = $item['requires_names'] ?? array();
$dependency_locked = ! empty( $item['dependency_locked'] );
$dependency_of_names = $item['dependency_of_names'] ?? array();

$is_disabled = false;
$checkbox_checked = false;
$price_display = '';
$status_display = '';
$disabled_attr = ''; // Initialize disabled_attr

if ( $is_child_theme ) {
    $is_disabled = true;
    $checkbox_checked = false;
    $price_display = esc_html__( '子佈景主題為客製主題無法估價', 'i10n-push-subscriber' );
    $status_display = esc_html__( '子佈景主題', 'i10n-push-subscriber' );
} elseif ( 'official_translation' === $tier ) {
    $is_disabled = true;
    $checkbox_checked = true; // Visually checked, but disabled
    $price_display = esc_html__( '使用官方翻譯無需訂閱', 'i10n-push-subscriber' );
    $status_display = esc_html__( '官方翻譯', 'i10n-push-subscriber' );
} elseif ( 'non_translatable' === $tier ) {
    $is_disabled = true;
    $checkbox_checked = false;
    $price_display = esc_html__( '作者未遵循翻譯規範', 'i10n-push-subscriber' );
    $status_display = esc_html__( '無法翻譯', 'i10n-push-subscriber' );
} elseif ( 'free' === $tier && $is_active ) {
    $is_disabled = true;
    $checkbox_checked = false;
    $price_display = esc_html__( '免費翻譯無需訂閱', 'i10n-push-subscriber' );
    $status_display = esc_html__( '免費翻譯', 'i10n-push-subscriber' );
} elseif ( $dependency_locked && ! $is_subscribed ) {
    $is_disabled = true;
    $checkbox_checked = false;
    $price_display = $format_price_display( $price, $source );
    if ( ! empty( $dependency_of_names ) && is_array( $dependency_of_names ) ) {
        $status_display = sprintf(
            /* translators: %s: dependent item names */
            esc_html__( '相依於：%s', 'i10n-push-subscriber' ),
            implode( ', ', array_map( 'esc_html', $dependency_of_names ) )
        );
    } else {
        $status_display = esc_html__( '相依項目不可訂閱', 'i10n-push-subscriber' );
    }
} elseif ( ! $is_active && 'official_translation' !== $tier ) {
    $is_disabled = true;
    $checkbox_checked = false;
    $price_display = $format_price_display( $price, $source );
    $status_display = esc_html__( '未啟用不得訂閱', 'i10n-push-subscriber' );
} elseif ( $dependency_missing && ! $is_subscribed ) {
    $is_disabled = true;
    $checkbox_checked = false;
    $price_display = $format_price_display( $price, $source );
    if ( ! empty( $requires_names ) && is_array( $requires_names ) ) {
        $status_display = sprintf(
            /* translators: %s: required item names */
            esc_html__( '需先啟用前置項目：%s', 'i10n-push-subscriber' ),
            implode( ', ', array_map( 'esc_html', $requires_names ) )
        );
    } else {
        $status_display = esc_html__( '需先啟用前置項目', 'i10n-push-subscriber' );
    }
} elseif ( isset($item['status']) && 'pending_payment' === $item['status'] ) {
    $status_display = esc_html__( '未訂閱', 'i10n-push-subscriber' );
    $expires_at = esc_html__( '等待確認中', 'i10n-push-subscriber' );
    $status_class = 'status-pending';
    $disabled_attr = 'disabled checked'; // Show as checked but disabled
} elseif ( 'quote_required' === $tier ) {
    $price_display = esc_html__( '(待報價)', 'i10n-push-subscriber' );
    $status_display = esc_html__( '待報價', 'i10n-push-subscriber' );
} elseif ( $is_subscribed ) {
    $is_disabled = true;
    $checkbox_checked = true;
    $price_display = $format_price_display( $price, $source );
    $status_display = esc_html__( '已訂閱', 'i10n-push-subscriber' );
} else {
    $price_display = $format_price_display( $price, $source );
    $status_display = esc_html__( '未訂閱', 'i10n-push-subscriber' );
}

$row_classes = 'tier-' . $tier . ( $is_subscribed ? ' status-subscribed subscribed-bg-highlight' : '' );
// Add status-pending class if applicable
if ( isset($item['status']) && 'pending_payment' === $item['status'] ) {
    $row_classes .= ' status-pending';
}
if ( 'designated-free' === $source ) {
    $row_classes .= ' designated-free-row';
} elseif ( 'quote_required' === $tier ) {
    $row_classes .= ' quote-required-row';
}
?>
<tr class="<?php echo esc_attr( $row_classes ); ?>">
    <th scope="row" class="check-column">
        <input type="checkbox" class="subscription-checkbox" name="i10n_push_subscriptions[]" value="<?php echo esc_attr( $item['text_domain'] ); ?>" data-price="<?php echo esc_attr( (int) $price ); ?>" data-tier="<?php echo esc_attr( $tier ); ?>" data-source="<?php echo esc_attr( $source ); ?>" data-po-file-url="<?php echo esc_attr( $item['po_file_url'] ?? '' ); ?>" <?php checked( $checkbox_checked ); disabled( $is_disabled ); ?><?php echo $disabled_attr ? ' ' . esc_attr( $disabled_attr ) : ''; ?> />
    </th>
    <td><strong><?php echo esc_html( $item['name'] ); ?></strong></td>
    <td><?php
        $source_display_text = '';
        switch ( $source ) {
            case 'official':
                $source_display_text = esc_html__( '官方', 'i10n-push-subscriber' );
                break;
            case 'designated-free':
                $source_display_text = esc_html__( '指定免費', 'i10n-push-subscriber' );
                break;
            case 'commercial':
                $source_display_text = esc_html__( '商業版', 'i10n-push-subscriber' );
                break;
            case '3rdparty':
                $source_display_text = esc_html__( '第三方', 'i10n-push-subscriber' );
                break;
            default:
                $source_display_text = esc_html__( '未知', 'i10n-push-subscriber' );
                break;
        }
        echo esc_html( $source_display_text );
    ?></td>
    <td class="status-cell">
        <?php echo esc_html( $status_display ); ?>
    </td>
    <td><?php echo esc_html( $item['official_translation_percent'] . '%' ); ?></td>
    <td><?php echo esc_html( $expires_at ? $expires_at : '-' ); ?></td>
    <td class="price-cell">
        <?php echo esc_html( $price_display ); ?>
    </td>
</tr>
