<?php
/**
 * Plugin Name: WordPress 中文補完計劃
 * Plugin URI: https://gordon168.com/i10n-push-subscriber/
 * Description: 透過自動化服務，為您的 WordPress 網站提供高品質的繁體中文翻譯補完方案，確保外掛與佈景主題的翻譯始終保持最新。
 * Version: 1.2.4
 * Author: 高登工作室
 * Author URI: https://gordon168.com/
 * Text Domain: i10n-push-subscriber
 * Domain Path: /languages
 * License: GPL-2.0-or-later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Requires at least: 6.8
 * Requires PHP: 8.1
 */

// Prevent direct access to the file
if ( ! defined( 'WPINC' ) ) {
    die;
}

// Define plugin constants
define( 'I10N_PUSH_SUBSCRIBER_VERSION', '1.2.4' );
define( 'I10N_PUSH_SUBSCRIBER_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'I10N_PUSH_SUBSCRIBER_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'I10N_PUSH_SUBSCRIBER_BASENAME', plugin_basename( __FILE__ ) );
define( 'I10N_PUSH_API_URL', 'https://api.gordon168.com' );
define( 'I10N_PUSH_CUSTOM_LANG_DIR', WP_CONTENT_DIR . '/i10n-push' );

// Optional: Define this constant in wp-config.php to enable development mode
// define( 'I10N_PUSH_DEV_MODE', true );
// Optional: Define this constant in wp-config.php to enable debug logging
// define( 'I10N_PUSH_DEBUG', true );

if ( ! function_exists( 'i10n_push_log' ) ) {
    function i10n_push_log( $message ) {
        if ( defined( 'I10N_PUSH_DEBUG' ) && I10N_PUSH_DEBUG ) {
            error_log( $message );
        }
    }
}

// Include necessary files
// require_once I10N_PUSH_SUBSCRIBER_PLUGIN_DIR . 'includes/class-i10n-push-subscriber-activator.php';
// require_once I10N_PUSH_SUBSCRIBER_PLUGIN_DIR . 'includes/class-i10n-push-subscriber-deactivator.php';
require_once I10N_PUSH_SUBSCRIBER_PLUGIN_DIR . 'includes/class-i10n-push-subscriber.php';

/**
 * The code that runs during plugin activation.
 */
function activate_i10n_push_subscriber() {
    update_option( 'i10n_push_force_update_on_activation', 1 );
    delete_transient( 'i10n_push_available_items' );
}
register_activation_hook( __FILE__, 'activate_i10n_push_subscriber' );

/**
 * The code that runs during plugin deactivation.
 */
function deactivate_i10n_push_subscriber() {
    $base = trailingslashit( I10N_PUSH_CUSTOM_LANG_DIR );
    $targets = array( $base . 'plugins', $base . 'themes' );
    foreach ( $targets as $target ) {
        if ( ! is_dir( $target ) ) {
            continue;
        }
        $iterator = new RecursiveIteratorIterator(
            new RecursiveDirectoryIterator( $target, FilesystemIterator::SKIP_DOTS ),
            RecursiveIteratorIterator::CHILD_FIRST
        );
        foreach ( $iterator as $file ) {
            if ( $file->isFile() ) {
                @unlink( $file->getPathname() );
            }
        }
    }

    // Clear translation timestamp options and update-check transients.
    $timestamp_keys = get_option( 'i10n_push_translation_timestamp_keys', array() );
    if ( ! empty( $timestamp_keys ) ) {
        foreach ( $timestamp_keys as $timestamp_key ) {
            delete_option( $timestamp_key );
        }
    } else {
        $all_options = wp_load_alloptions();
        foreach ( $all_options as $option_name => $option_value ) {
            if ( 0 === strpos( $option_name, 'i10n_push_translation_timestamp_' ) ) {
                delete_option( $option_name );
            }
        }
    }
    delete_option( 'i10n_push_translation_timestamp_keys' );

    $update_check_keys = get_option( 'i10n_push_update_check_keys', array() );
    foreach ( $update_check_keys as $update_check_key ) {
        delete_transient( $update_check_key );
    }
    delete_option( 'i10n_push_update_check_keys' );

    delete_option( 'i10n_push_last_status_check' );
    delete_transient( 'i10n_push_available_items' );
    delete_transient( 'i10n_push_api_error' );
}
register_deactivation_hook( __FILE__, 'deactivate_i10n_push_subscriber' );

/**
 * Begins execution of the plugin.
 *
 * Since all plugin logic will be encapsulated in classes,
 * we'll instantiate the main plugin class here.
 */
function run_i10n_push_subscriber() {
    // Initialize Plugin Self-Updater
    if ( is_admin() ) {
        require_once I10N_PUSH_SUBSCRIBER_PLUGIN_DIR . 'includes/class-i10n-push-plugin-updater.php';
        new I10n_Push_Plugin_Updater( 'i10n-push-subscriber', I10N_PUSH_SUBSCRIBER_VERSION );
    }

    $plugin = new I10n_Push_Subscriber();
    $plugin->run();
}
run_i10n_push_subscriber();
