<?php

/**
 * Define the internationalization functionality
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @link       https://gordon178.com/
 * @since      1.0.0
 *
 * @package    I10n_Push_Subscriber
 * @subpackage I10n_Push_Subscriber/includes
 */

/**
 * Define the internationalization functionality.
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @since      1.0.0
 * @package    I10n_Push_Subscriber
 * @subpackage I10n_Push_Subscriber/includes
 * @author     Gordon <gordon@gordon178.com>
 */
class I10n_Push_Subscriber_i18n {

    /**
     * Load the plugin text domain for translation.
     *
     * @since    1.0.0
     */
    public function load_plugin_textdomain() {
        load_plugin_textdomain(
            'i10n-push-subscriber',
            false,
            dirname( plugin_basename( __FILE__ ), 2 ) . '/languages/'
        );
    }
}